-- Macro_Scripts File
-- Purpose:  define action for each creatable Particles Systems objects to hook up to the create main menu (or quads)

/*
Revision History

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

	24 Mai 2003: Pierre-felix Breton
	created for 3ds MAX 6
	
	Nov 17 1998: Frank Delise
	created
*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

---------------------------------------------------------------------------
macroScript PFFindTarget
            category:~PFFINDTARGET_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PFFINDTARGET_TOOLTIP~ 
            buttontext:~PFFINDTARGET_BUTTONTEXT~ 
            --Icon:#("Particles",3)
(
    on execute do StartObjectCreation Find_Target
    on isChecked return mcrUtils.IsCreating Find_Target
)

---------------------------------------------------------------------------
macroScript PFSpeedByIcon
            category:~PFSPEEDBYICON_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PFSPEEDBYICON_TOOLTIP~ 
            buttontext:~PFSPEEDBYICON_BUTTONTEXT~ 
            --Icon:#("Particles",3)
(
    on execute do StartObjectCreation SpeedByIcon
    on isChecked return mcrUtils.IsCreating SpeedByIcon
)

---------------------------------------------------------------------------
macroScript PFParticlePaint
            category:~PFPARTICLEPAINT_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PFPARTICLEPAINT_TOOLTIP~ 
            buttontext:~PF_PARTICLEPAINT_BUTTONTEXT~
(
    on execute do StartObjectCreation Particle_Paint
    on isChecked return mcrUtils.IsCreating Particle_Paint
)

---------------------------------------------------------------------------
macroScript PFBirthTexture
            category:~PFBIRTHTEXTURE_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PFBIRTHTEXTURE_TOOLTIP~ 
            buttontext:~PFBIRTHTEXTURE_BUTTONTEXT~ 
(
    on execute do StartObjectCreation Birth_Texture
    on isChecked return mcrUtils.IsCreating Birth_Texture
)

---------------------------------------------------------------------------
macroScript PFInitialState
            category:~PFINITIALSTATE_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PFINITIALSTATE_TOOLTIP~ 
            buttontext:~PFINITIALSTATE_BUTTONTEXT~ 
(
    on execute do StartObjectCreation Initial_State
    on isChecked return mcrUtils.IsCreating Initial_State
)

---------------------------------------------------------------------------
macroScript PFGroupSelect
            category:~PFGROUPSELECT_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PFGROUPSELECT_TOOLTIP~ 
            buttontext:~PFGROUPSELECT_BUTTONTEXT~ 
(
    on execute do StartObjectCreation Group_Select
    on isChecked return mcrUtils.IsCreating Group_Select
)

---------------------------------------------------------------------------
macroScript PFSource
            category:~PFSOURCE_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~PFSOURCE_TOOLTIP~ 
            buttontext:~PFSOURCE_BUTTONTEXT~ 
            --Icon:#("Particles",3)
(
    on execute do StartObjectCreation PF_Source
    on isChecked return mcrUtils.IsCreating PF_Source
)
---------------------------------------------------------------------------
macroScript PArray
            category:~PARRAY_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~PARRAY_TOOLTIP~ 
            buttontext:~PARRAY_BUTTONTEXT~ 
            Icon:#("Particles",3)
(
    on execute do StartObjectCreation PArray
    on isChecked return mcrUtils.IsCreating PArray
)
---------------------------------------------------------------------------
macroScript PCloud
            category:~PCLOUD_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~PCLOUD_TOOLTIP~ 
            buttontext:~PCLOUD_BUTTONTEXT~ 
            Icon:#("Particles",6)
(
    on execute do StartObjectCreation PCloud 
    on isChecked return mcrUtils.IsCreating PCloud
)
---------------------------------------------------------------------------
macroScript Blizzard
            category:~BLIZZARD_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~BLIZZARD_TOOLTIP~ 
            buttontext:~BLIZZARD_BUTTONTEXT~ 
            Icon:#("Particles",5)
(
    on execute do StartObjectCreation Blizzard 
    on isChecked return mcrUtils.IsCreating Blizzard
)
---------------------------------------------------------------------------
macroScript SuperSpray
            category:~SUPERSPRAY_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~SUPERSPRAY_TOOLTIP~
			buttontext:~SUPERSPRAY_BUTTONTEXT~ 
            Icon:#("Particles",2)
(
    on execute do StartObjectCreation SuperSpray 
    on isChecked return mcrUtils.IsCreating SuperSpray
)
---------------------------------------------------------------------------
macroScript Spray
            category:~SPRAY_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~SPRAY_TOOLTIP~ 
            buttontext:~SPRAY_BUTTONTEXT~ 
            Icon:#("Particles",1)
(
    on execute do StartObjectCreation Spray
    on isChecked return mcrUtils.IsCreating Spray
)
---------------------------------------------------------------------------
macroScript Snow
            category:~SNOW_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~SNOW_TOOLTIP~ 
            buttontext:~SNOW_BUTTONTEXT~ 
            Icon:#("Particles",4)
(
    on execute do StartObjectCreation Snow 
    on isChecked return mcrUtils.IsCreating Snow
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQDJcb3Ko+Ctu1jA0lbDYAJq3Ocv6I3Ra9fG
-- SbHyTcDcWXVTtUFxmXkyIRAMQ3HlnXZzcVD8yGh2FP6jJFrosBsgwztfWcyvwCW2
-- 1x80Xaa+OQJXWdDoQTVZ0pMFJJjuyUVhiBqenmte48KgPYTZpUWbyckUGeBTjYKA
-- qGDgCn8yiePRetyqui1XdA7oEPEKAK9/b3ATB0uxh0/0v5uFjevo3oVjthkeDZbr
-- IVEQOjKp3bkes5PR3o1G6oqtEis4ctjZ6VylW1I7KhtvPP6bpFTjJkR1QQFAfhuK
-- byFtI6WW0RERz2AtPPP9Q5I95Yh6IUVDwqbl/D/ADOUe/97ZuQQI
-- -----END-SIGNATURE-----